from django.urls import path
from . import views
from .views import StockReportView, StockReportPDFView

urlpatterns = [
    path('', views.cashier_view, name='cashier'),
    path('<int:transaction_id>/', views.cashier_update, name='cashier_update'),
    path('get-product/', views.get_product, name='get_product'),
    path('search-products/', views.search_products, name='search_products'),
    path('save-transaction/', views.save_transaction, name='save_transaction'),
    path('search-employees/', views.search_employees, name='search_employees'),
    path('search-customers/', views.search_customers, name='search_customers'),
    path('add_customer/', views.add_customer, name='add_customer'),
    path('report/', StockReportView.as_view(), name='report'),
    path('report/pdf/', StockReportPDFView.as_view(), name='report_pdf'),
    path('print-invoice/<int:transaction_id>/', views.print_invoice, name='print_invoice'),
    path('print-invoice/<int:transaction_id>/pdf/', views.transaction_invoice_pdf, name='transaction_invoice_pdf'),
]