from django.shortcuts import render
from .models import Employee, Supplier, Customer
import openpyxl
from django.http import HttpResponse, FileResponse
from django.contrib.admin.views.decorators import staff_member_required
from django.conf import settings
import os
from django.http import Http404
from django.utils.translation import gettext_lazy as _

# Create your views here.
def employee_list(request):
    employees = Employee.objects.all()
    return render(request, 'employee.html', {'employees': employees})

def supplier_list(request):
    suppliers = Supplier.objects.all()
    return render(request, 'supplier.html', {'suppliers': suppliers})

def customer_list(request):
    customers = Customer.objects.all()
    return render(request, 'customer.html', {'customers': customers})

def download_template(request):
    try:
        app_template_path = os.path.join(settings.BASE_DIR, 'management', 'static', 'templates', 'customer_import.xlsx')
        
        if os.path.exists(app_template_path):
            template_path = app_template_path
        else:
            raise Http404("Template file tidak ditemukan")
            
        return FileResponse(
            open(template_path, 'rb'),
            as_attachment=True,
            filename='customer_import.xlsx'
        )
    except Exception as e:
        raise Http404(f"Error saat mengunduh template: {str(e)}")