from django import template
from decimal import Decimal

register = template.Library()

@register.filter
def rupiah(value):
    try:
        value = Decimal(value)
    except (ValueError, TypeError):
        return "Rp 0,00"
    return "Rp {:,.2f}".format(value)