"""
Django settings for App project.

Generated by 'django-admin startproject' using Django 5.1.1.

For more information on this file, see
https://docs.djangoproject.com/en/5.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.1/ref/settings/
"""

from pathlib import Path
import os
from decouple import config

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = config('DJANGO_SECRET_KEY')

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    "unfold",
    "django.contrib.admin",
    "unfold.contrib.import_export",
    "django.contrib.staticfiles",
    "django.contrib.messages",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.auth",
    "categories",
    "transaction",
    "management",
    "import_export",
]

MIDDLEWARE = [
    'django.middleware.locale.LocaleMiddleware',
    "django.middleware.security.SecurityMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
]

ROOT_URLCONF = "App.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [os.path.join(BASE_DIR, "templates")],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    },
]

WSGI_APPLICATION = "App.wsgi.application"


# Database
# https://docs.djangoproject.com/en/5.1/ref/settings/#databases

DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.mysql",
        "NAME": "kasir",
        "USER": "root",
        "PASSWORD": "",
        "HOST": "127.0.0.1",
        "PORT": "3306",
    }
}


# Password validation
# https://docs.djangoproject.com/en/5.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.MinimumLengthValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.CommonPasswordValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.NumericPasswordValidator",
    },
]


# Internationalization
# https://docs.djangoproject.com/en/5.1/topics/i18n/

LANGUAGE_CODE = "en-US"

TIME_ZONE = "Asia/Jakarta"

USE_I18N = True
USE_L10N = True


USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.1/howto/static-files/

STATIC_URL = "/static/"
STATICFILES_DIRS = [
    BASE_DIR / "categories/static",
    BASE_DIR / "management/static",
    BASE_DIR / "transaction/static",
]
STATIC_ROOT = os.path.join(BASE_DIR, "static")

# Default primary key field type
# https://docs.djangoproject.com/en/5.1/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = "django.db.models.BigAutoField"

# Durasi session (misalnya, 30 menit = 1800 detik)
SESSION_COOKIE_AGE = 3600  # 60 minutes

# Nonaktifkan perpanjangan waktu otomatis
SESSION_SAVE_EVERY_REQUEST = True

# Hapus session saat browser ditutup
SESSION_EXPIRE_AT_BROWSER_CLOSE = True

MIDDLEWARE += [
    "App.middleware.SessionTimeoutMiddleware",  # Ganti "App" dengan nama aplikasi Anda
]

LOGIN_URL = "/admin/"
LOGIN_REDIRECT_URL = "/"

from django.templatetags.static import static
from django.urls import reverse_lazy
from django.utils.translation import gettext_lazy as _


UNFOLD = {
    #"SITE_LOGO": {
    #    "light": "/static/img/Logo2.png",
    #    "dark": "/static/img/logoputih.png"
    #},
    "SITE_TITLE": "SBMS Connect Cashier Management",
    "SITE_TITLE_SHORT": "Cashier",
    "SITE_ICONS": "Cashier",

    "SITE_HEADER": "SBMS Connect",

    "SITE_URL": "/",
    "SHOW_HISTORY": True,
    
    "COLORS": {
        "primary": {
            "50": "250 245 255",
            "100": "243 232 255",
            "200": "233 213 255",
            "300": "216 180 254",
            "400": "192 132 252",
            "500": "168 85 247",
            "600": "147 51 234",
            "700": "126 34 206",
            "800": "107 33 168",
            "900": "88 28 135",
        },
    },
    "EXTENSIONS": {
        "modeltranslation": {
            "flags": {
                "en": "🇬🇧",
                "fr": "🇫🇷",
                "nl": "🇧🇪",
            },
        },
    },
    "SIDEBAR": {
        "show_search": True,
        "show_all_applications": False,
        "collapsible": True,
        "navigation": [
            {
                "title": _("Dashboard"),
                "separator": True,
                "collapsible": False,
                "items": [
                    {
                        "title": _("Home"),
                        "icon": "home",
                        "link": reverse_lazy("admin:index"),
                    },
                ],
            },
            {
                "title": _("Authentication and Authorization"),
                "separator": True,
                "collapsible": False,
                "items": [
                    {
                        "title": _("Groups"),
                        "icon": "Groups",
                        "link": reverse_lazy("admin:auth_group_changelist"),
                        "permission": lambda request: request.user.is_superuser,
                    },
                    {
                        "title": _("Users"),
                        "icon": "Person",
                        "link": reverse_lazy("admin:auth_user_changelist"),
                        "permission": lambda request: request.user.is_superuser,
                    },
                ],
            },
            {
                "title": _("Product Management"),
                "separator": True,
                "collapsible": False,
                "items": [
                    {
                        "title": _("Product Categories"),
                        "icon": "store",
                        "link": reverse_lazy("admin:categories_category_changelist"),
                        "permission": lambda request: request.user.has_perm(
                            "categories.view_category"
                        ),
                    },
                    {
                        "title": _("Products"),
                        "icon": "shopping_bag",
                        "link": reverse_lazy("admin:categories_product_changelist"),
                        "permission": lambda request: request.user.has_perm(
                            "categories.view_product"
                        ),
                    },
                ],
            },


            {
                "title": _("Data Management"),
                "separator": True,
                "collapsible": False,
                "items": [
                    {
                        "title": _("Employees"),
                        "icon":"badge",
                        "link": reverse_lazy("admin:management_employee_changelist"),
                        "permission": lambda request: request.user.has_perm(
                            "management.view_employee"
                        ),
                    },
                    {
                        "title": _("Suppliers"),
                        "icon": "local_shipping",
                        "link": reverse_lazy("admin:management_supplier_changelist"),
                        "permission": lambda request: request.user.has_perm(
                            "management.view_supplier"
                        ),
                    },
                    {
                        "title": _("Customers"),
                        "icon": "group",
                        "link": reverse_lazy("admin:management_customer_changelist"),
                        "permission": lambda request: request.user.has_perm(
                            "management.view_customer"
                        ),
                    },
                ],
            },
            {
                "title": _("Transactions"),
                "separator": True,
                "collapsible": False,
                "items": [
                    {
                        "title": _("Cashier and Reports"),
                        "icon":"receipt_long",
                        "link": reverse_lazy("admin:transaction_transaction_changelist"),
                        "permission": lambda request: request.user.has_perm(
                            "transaction.view_transaction"
                        ),
                    },
                ],
            },
        ],
    },
}
