from django.contrib import admin
from django.contrib.auth.models import User, Group
from django.contrib.auth.admin import UserAdmin
from django.contrib.auth.models import Permission
from django.contrib.contenttypes.models import ContentType
from unfold.admin import ModelAdmin as UnfoldModelAdmin

# Custom User Admin to include UnfoldModelAdmin (without modifying UserAdmin directly)
@admin.register(User)
class CustomUserAdmin(UnfoldModelAdmin, admin.ModelAdmin):
    list_display = ('username', 'email', 'first_name', 'last_name', 'is_staff', 'is_active')
    search_fields = ('username', 'email')
    list_filter = ('is_staff', 'is_active', 'groups')
    list_per_page = 10

# Custom Group Admin with UnfoldModelAdmin
@admin.register(Group)
class CustomGroupAdmin(UnfoldModelAdmin, admin.ModelAdmin):
    list_display = ('name', 'permissions_count')
    search_fields = ('name',)
    list_per_page = 10

    def permissions_count(self, obj):
        return obj.permissions.count()
    permissions_count.short_description = 'Permissions Count'
